/*____________________________________________________________________________
	Copyright (C) 2000 Networks Associates Technology, Inc.
	All rights reserved.

	pgpGeneric.c - handle "generic" driver requests
	

	$Id: pgpGeneric.c,v 1.2 2000/02/01 17:55:29 pbj Exp $
____________________________________________________________________________*/

#include "pgpUDx.h"
#include "PGPsdkDriver.h"
#include "pgpDriverVersion.h"
#include "pgpGeneric.h"

//	______________________________________________________
//
//	This is the function that processes the DeviceIoControl
//	call which is coming down from the Win32 application.

VOID
pgpGenericProcessOperation (
    IN PPGPGENERICSTRUCT	ppgs,
	IN ULONG				ulStatusFlags)
{
	switch (ppgs->ulOperation) {

	case kPGPUDOperation_QueryVersion :
		strcpy ((CHAR*)&ppgs->ucBuffer[0], VERSIONSTRING);
		ppgs->ulError = kPGPUDError_NoErr;
		break;

	case kPGPUDOperation_QueryStatus :
		ppgs->ulFlags = ulStatusFlags;
		ppgs->ulError = kPGPUDError_NoErr;
		break;

	default :
		ppgs->ulError = kPGPUDError_UndefinedOperation;
		break;
	}
}

